#include(rules-dist.inc)

[top]
components : populationGen
in : dist-average-gen-one dist-average-ext-one
in : dist-average-gen-two dist-average-ext-two
in : dist-average-gen-three dist-average-ext-three
link : dist-average-gen-one inputDistAverageGenOne@populationGen
link : dist-average-ext-one inputDistAverageExtOne@populationGen
link : dist-average-gen-two inputDistAverageGenTwo@populationGen
link : dist-average-ext-two inputDistAverageExtTwo@populationGen
link : dist-average-gen-three inputDistAverageGenThree@populationGen
link : dist-average-ext-three inputDistAverageExtThree@populationGen

[populationGen]
type : cell
dim : (25,25)
delay : transport
defaultDelayTime : 100
border : wrapped 

neighbors : populationGen(0,0) 
neighbors : populationGen(-1,-1)  populationGen(1,1)  populationGen(-1,1)  populationGen(1,-1)
neighbors : populationGen(-2,-2)  populationGen(2,2)  populationGen(-2,2)  populationGen(2,-2)
neighbors : populationGen(-3,-3)  populationGen(3,3)  populationGen(-3,3)  populationGen(3,-3)
neighbors : populationGen(-2,0)  populationGen(-1,0)  populationGen(1,0)  populationGen(2,0)
neighbors : populationGen(0,-2)  populationGen(0,-1)  populationGen(0,1)  populationGen(0,2)
neighbors : populationGen(0,-3)  populationGen(-3,0)  populationGen(3,0)  populationGen(0,3)
neighbors : populationGen(1,3)  populationGen(1,2)  populationGen(1,-3)  populationGen(1,-2)
neighbors : populationGen(-1,3)  populationGen(-1,2)  populationGen(-1,-3)  populationGen(-1,-2)
neighbors : populationGen(3,1)  populationGen(2,1)  populationGen(3,-1)  populationGen(2,-1)
neighbors : populationGen(-3,1)  populationGen(-2,1)  populationGen(-3,-1)  populationGen(-2,-1)
neighbors : populationGen(2,3)  populationGen(2,-3)  populationGen(-2,3)  populationGen(-2,-3)
neighbors : populationGen(3,2)  populationGen(3,-2)  populationGen(-3,2)  populationGen(-3,-2)

in : inputDistAverageGenOne inputDistAverageExtOne
in : inputDistAverageGenTwo inputDistAverageExtTwo
in : inputDistAverageGenThree inputDistAverageExtThree

link : inputDistAverageGenOne in-gen-one@populationGen(4,4)
link : inputDistAverageExtOne in-ext-one@populationGen(8,8)
link : inputDistAverageGenTwo in-gen-two@populationGen(15,15)
link : inputDistAverageExtTwo in-ext-two@populationGen(5,15)
link : inputDistAverageGenThree in-gen-three@populationGen(18,15)
link : inputDistAverageExtThree in-ext-three@populationGen(10,15)

initialvalue : 0
stateVariables: hum act ext avggen avgext 
stateValues: 0 0 0 0 0
NeighborPorts: hum act ext avggen avgext

localtransition : population-gen
portInTransition : in-gen-one@populationGen(4,4) set-average-gen
portInTransition : in-ext-one@populationGen(8,8) set-average-ext
portInTransition : in-gen-two@populationGen(15,15) set-average-gen
portInTransition : in-ext-two@populationGen(5,15) set-average-ext
portInTransition : in-gen-three@populationGen(18,15) set-average-gen
portInTransition : in-ext-three@populationGen(10,15) set-average-ext

[population-gen]
rule : 	{ ~out := 10; ~ext := $ext; ~act := $act;
          ~avggen := 0;  ~avgext := 0; }
		{ $hum := #macro(hum-change); $ext := #macro(ext-change); $act := #macro(act-change);
          $avggen := #macro(avggen-change); $avgext := #macro(avgext-change); } 
		100 {$ext = 0 AND ((0,0) = 10 OR $act = 1)}
rule :  { ~out := 0; ~ext := $ext; ~act := $act; 
          ~avggen := 0;  ~avgext := 0; }
		{ $hum := #macro(hum-change); $ext := #macro(ext-change); $act := #macro(act-change);
          $avggen := #macro(avggen-change); $avgext := #macro(avgext-change); }
		500 {$ext = 1 AND (0,0) = 10}
rule :  { ~out := 0; ~ext := $ext; ~act := $act;
          ~avggen := 0;  ~avgext := 0; }
		{ $hum := #macro(hum-change); $ext := #macro(ext-change); $act := #macro(act-change);
          $avggen := #macro(avggen-change); $avgext := #macro(avgext-change); }
		100 {t}

[set-average-gen]
rule : 	{ ~out := 10; ~hum := $hum; ~ext := $ext; ~act := $act;
          ~avggen := portValue(thisPort); }
		{ $hum := #macro(hum-change); $ext := #macro(ext-change); $act := #macro(act-change);
          $avggen := $avggen + portValue(thisPort); $avgext := #macro(avgext-change); }
	   100 {$ext = 0 AND ((0,0) = 10 OR $act = 1)}
rule :  { ~out := 0; ~hum := $hum; ~ext := $ext; ~act := $act;
          ~avggen := portValue(thisPort); }
		{ $hum := #macro(hum-change); $ext := #macro(ext-change); $act := #macro(act-change);
          $avggen := $avggen + portValue(thisPort); $avgext := #macro(avgext-change); }
	   500 {$ext = 1 AND (0,0) = 10}
rule :  { ~out := 0; ~hum := $hum; ~ext := $ext; ~act := $act;
          ~avggen := portValue(thisPort); }
   	    { $hum := #macro(hum-change); $ext := #macro(ext-change); $act := #macro(act-change);
          $avggen := $avggen + portValue(thisPort); $avgext := #macro(avgext-change); }
	   100 {t}

[set-average-ext]
rule :  { ~out := 10; ~ext := $ext; ~act := $act;
		  ~avgext := portValue(thisPort); }
		{ $hum := #macro(hum-change); $ext := #macro(ext-change); $act := #macro(act-change);
 		  $avgext := portValue(thisPort); $avggen := #macro(avggen-change); }
   	    100 {$ext = 0	AND ((0,0) = 10 OR $act = 1)}
rule :  { ~out := 0; ~ext := $ext; ~act := $act;
		  ~avgext := $avgext + portValue(thisPort); }
 	    { $hum := #macro(hum-change); $ext := #macro(ext-change); $act := #macro(act-change);
 		  $avgext := portValue(thisPort); $avggen := #macro(avggen-change);}
		500 {$ext = 1 AND (0,0) = 10}
rule :  { ~out := 0; ~hum := $hum; ~ext := $ext; ~act := $act;
		  ~avgext := $avgext + portValue(thisPort); }
		{ $hum := #macro(hum-change); $ext := #macro(ext-change); $act := #macro(act-change);
		  $avgext := $avgext + portValue(thisPort); $avggen := #macro(avggen-change); }
		100 {t}
